
import random
import json
from tqdm import tqdm
import torch
import base64
import requests
import re
import os
import openai




type_map = {}
with open('/home/yangyic3/yangyic3/PIG/PIGONE/data/filtered_questions.jsonl', 'r') as f:
    for line in f:
        data = json.loads(line.strip())
        question = data['Question']
        type_map[question] = data['Question Type']

prompt = '''
Your job is to pretend that you are a human talking with a vision-language model.
You will receive an image and a question about the image. Pretend that these are what you give to a vision-language model in previous conversation. You will also receive the model's initial response to the question. 
Please respond to the model's initial response carefully as if you are a human talking with the model.
Here's the question you asked the model in the previous conversation: {}
And here's the model's initial response: {}
'''

with open('/home/yangyic3/yangyic3/PIG/PIGONE/llavafinetune/eval_results/quark_flagged.jsonl', 'r') as f:
    data = [json.loads(line) for line in f]
    

def encode_image(image_path):
  with open(image_path, "rb") as image_file:
    return base64.b64encode(image_file.read()).decode('utf-8')


def chat_completion_with_backoff(**kwargs):
    return openai.ChatCompletion.create(**kwargs)

def call_OpenAI_api(question, response, image_path,model_="gpt-4-turbo",temp=0.7,max_gen_len=512):
    base64_image = encode_image(image_path)
    a = chat_completion_with_backoff(model=model_, \
        max_tokens=max_gen_len, temperature=temp, top_p=0.0, \
        logprobs=True, top_logprobs=10, messages=[
        {
        "role": "user",
        "content": [
            {"type": "text", "text": prompt.format(question, response)},
            {
            "type": "image_url",
            "image_url": {
                "url": f"data:image/jpeg;base64,{base64_image}",
            },
            },
        ],
        }
    ])
    return a["choices"][0]["message"]["content"], a["choices"][0]["logprobs"]["content"][0]["top_logprobs"]

# o, _ = call_OpenAI_api('Is the person wearing a hat?','2322322')
# print(o)


counts = 0
results = []
for item in tqdm(data):
    attempts = 0
    question_type = type_map[item['question']]
    question = item['question']
    response = item['answer']
    if question_type == 'Hidden Human Preferences' and item['evaluation'].split('Flag:')[-1].strip() == 'True':
        while attempts <3:
            try:
                item['roundtwo'], _ = call_OpenAI_api(question, response, item['img_path'])
                results.append(item)
                counts += 1
                break
            except:
                print(f"Failed to generate questions for image {item['img_path']}.")
                attempts += 1          
    else:
        continue

with open('/home/yangyic3/yangyic3/PIG/PIGONE/llavafinetune/multiturn/gpt4v_generated.jsonl', 'w') as f:
    for result in results:
        f.write(json.dumps(result) + '\n')




# with open('/home/yangyic3/yangyic3/PIG/PIGONE/data/llava/llava_SA_selfcheck.jsonl', 'w') as f:
#     for result in results:
#         f.write(json.dumps(result) + '\n')